%% gaussian_meet.m

%% Function to compute the Gaussian approximation in  Equations 
%% (A-10) and (A-11)  (in the book Uncertain Rule-Based Fuzzy 
%% Logic Systems: Introduction and New Directions, by Jerry M. Mendel, 
%% and published by Prentice-Hall, 2000) to the meet of "n" Gaussian 
%% type-1 fuzzy sets under product t-norm .

%% Written by Nilesh N. Karnik - July 21,1998
%% For use with MATLAB 5.1 or higher.
 
%% Outputs : "m_out" and "s_out" (scalars) are, respectively, the 
%% mean and standard deviation of the Gaussian approximated "meet" 
%% of the "n" type-1 Gaussians. 

%% Inputs : "m" and "s" are both n-vectors, containing the means and 
%% standard deviations of the "n" Gaussians. All the means are assumed to
%% be in [0,1], and all the standard deviations are positive.

function[m_out,s_out] = gaussian_meet(m,s)

m_out = prod(m) ;

if size(m,1) == 1,
   m = m' ;
end 

m1 = m * ones(1,length(m)) ;

m2 = m1 - diag(m) ;

s1 = diag(s) ;

ms = max(m2 , s1) ;

s_out = sqrt(sum(prod(ms.^2))) ;


return ;
